/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.ElephantConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ElephantEntity
extends TamableAnimal
implements NeutralMob,
HasCustomInventoryScreen,
ILexiconEntry {
    public static final int ANGER_TIME = 10;
    private static final UniformInt rangedInteger = TimeUtil.m_145020_((int)20, (int)39);
    private static Component CONTAINER_NAME = null;
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.m_135353_(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_CHEST = SynchedEntityData.m_135353_(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected SimpleContainer entityInventory;
    private int tameAmount;
    private int attackTimer;
    private UUID angerTarget;

    public ElephantEntity(EntityType<ElephantEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_274367_(1.0f);
        this.initInventory();
        this.tameAmount = 0;
    }

    public static boolean checkElephantSpawnRules(EntityType<ElephantEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.ELEPHANT_SPAWNABLE_ON) && ElephantEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_SADDLED, (Object)false);
        this.m_20088_().m_135372_(HAS_CHEST, (Object)false);
        this.m_20088_().m_135372_(REMAINING_ANGER_TIME, (Object)0);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        ElephantEntity child = (ElephantEntity)ModEntityTypes.ELEPHANT.get().m_20615_(this.m_9236_());
        if (this.m_21824_() || ((ElephantEntity)parent).m_21824_()) {
            child.m_7105_(true);
        }
        return child;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ElephantConfig.health()).m_22268_(Attributes.f_22279_, ElephantConfig.movementSpeed()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, ElephantConfig.attackDamage());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.2, false, ElephantConfig::canAttack));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.95));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NewHurtByTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.m_9236_(), compound);
        this.setSaddled(compound.m_128471_("Saddled"));
        this.setHasChest(compound.m_128471_("Chested"));
        this.m_7105_(compound.m_128471_("Tamed"));
        this.tameAmount = compound.m_128451_("TameAmount");
        this.entityInventory.m_7797_(compound.m_128437_("Inventory", 10));
        this.initInventory();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
        compound.m_128379_("Saddled", this.isSaddled());
        compound.m_128379_("Chested", this.hasChest());
        compound.m_128379_("Tamed", this.m_21824_());
        compound.m_128405_("TameAmount", this.tameAmount);
        compound.m_128365_("Inventory", (Tag)this.entityInventory.m_7927_());
    }

    private void initInventory() {
        SimpleContainer inventory = this.entityInventory;
        this.entityInventory = new SimpleContainer(27);
        if (inventory == null) {
            return;
        }
        int invSize = Math.min(inventory.m_6643_(), this.entityInventory.m_6643_());
        for (int i = 0; i < invSize; ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            this.entityInventory.m_6836_(i, itemstack.m_41777_());
        }
    }

    private void openInventory(Player player) {
        if (!this.hasChest()) {
            return;
        }
        if (CONTAINER_NAME == null) {
            CONTAINER_NAME = ModEntityTypes.ELEPHANT.get().m_20676_();
        }
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInv, playerIn) -> new ChestMenu(MenuType.f_39959_, id, player.m_150109_(), (Container)this.entityInventory, 3), CONTAINER_NAME));
    }

    public void m_213583_(Player player) {
        this.openInventory(player);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.ELEPHANT_FOOD);
    }

    public boolean m_7327_(Entity target) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag) {
            target.m_20256_(target.m_20184_().m_82520_(0.0, 0.7, 0.0));
            this.m_19970_((LivingEntity)this, target);
        }
        return flag;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public int m_5792_() {
        return ElephantConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.925;
    }

    protected SoundEvent m_7515_() {
        return ModSounds.ELEPHANT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.ELEPHANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.ELEPHANT_DEATH.get();
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.attackTimer = 10;
                break;
            }
            case 6: {
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123808_);
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123815_);
                break;
            }
            case 7: {
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123749_);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    private void spawnParticle(ParticleOptions particle) {
        if (particle != null) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.03;
                double d1 = this.f_19796_.m_188583_() * 0.03;
                double d2 = this.f_19796_.m_188583_() * 0.03;
                this.m_9236_().m_7106_(particle, this.m_20208_(1.5), this.m_20187_() + 0.5, this.m_20262_(1.5), d0, d1, d2);
            }
        }
    }

    private void doPlayerRide(Player player) {
        if (!this.m_9236_().m_5776_()) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.entityInventory != null) {
            for (int i = 0; i < this.entityInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.entityInventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.isSaddled() && this.f_19796_.m_188499_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
        if (this.hasChest() && this.f_19796_.m_188499_()) {
            this.m_19998_((ItemLike)Items.f_42009_);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_6109_() && this.isSaddled()) {
                LivingEntity livingentity = this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float sideSpeed = livingentity.f_20900_ * 0.4f;
                float forwardSpeed = livingentity.f_20902_ * 0.7f;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.2f;
                }
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)sideSpeed, travelVector.f_82480_, (double)forwardSpeed));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_267651_(false);
            } else {
                super.m_7023_(travelVector);
            }
        }
    }

    public boolean isTamingItem(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.ELEPHANT_TAMING_FOOD);
    }

    public LivingEntity m_6688_() {
        Entity passenger = this.m_146895_();
        if (passenger instanceof Player) {
            return (Player)passenger;
        }
        return null;
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(IS_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(IS_SADDLED, (Object)saddled);
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CHEST);
    }

    public void setHasChest(boolean chested) {
        this.f_19804_.m_135381_(HAS_CHEST, (Object)chested);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(rangedInteger.m_214085_(this.f_19796_));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_(ModItems.LEXICON.get())) {
            return InteractionResult.PASS;
        }
        if (stack.m_41619_() && this.m_21824_() && !this.m_6162_()) {
            if (player.m_6047_() && this.hasChest()) {
                this.openInventory(player);
            } else if (this.m_20197_().isEmpty() && this.isSaddled()) {
                this.doPlayerRide(player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.m_6898_(stack)) {
            if (this.m_6162_()) {
                int age = this.m_146764_();
                this.m_142075_(player, hand, stack);
                this.m_146740_((int)((float)(-age / 20) * 0.1f), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (this.m_21824_()) {
                if (this.m_21223_() < this.m_21233_()) {
                    if (!this.m_9236_().m_5776_()) {
                        float healAmount = 3.0f;
                        this.m_5634_(healAmount);
                        this.m_142075_(player, hand, stack);
                    }
                } else if (!this.m_9236_().m_5776_() && !this.m_6162_() && this.m_35506_()) {
                    this.m_142075_(player, hand, stack);
                    this.m_27595_(player);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        } else {
            if (this.isTamingItem(stack) && !this.m_6162_() && !this.m_21824_()) {
                if (!this.m_9236_().m_5776_()) {
                    this.tameAmount += 200;
                    this.m_142075_(player, hand, stack);
                    if (this.tameAmount >= 1000) {
                        this.m_7105_(true);
                        this.m_21816_(player.m_20148_());
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
                        }
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_21824_() && stack.m_150930_(Items.f_42450_) && !this.m_6162_() && !this.isSaddled()) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_142075_(player, hand, stack);
                    this.setSaddled(true);
                    this.m_5496_(ModSounds.ELEPHANT_EQUIP_SADDLE.get(), 0.9f, 0.9f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (this.m_21824_() && this.isSaddled() && stack.m_150930_(Items.f_42009_) && !this.m_6162_() && !this.hasChest()) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_142075_(player, hand, stack);
                    this.setHasChest(true);
                    this.m_5496_(ModSounds.ELEPHANT_EQUIP_CHEST.get(), 0.9f, 0.9f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_35506_() {
        return this.m_5957_();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.ELEPHANT;
    }

    private static class NewHurtByTargetGoal
    extends HurtByTargetGoal {
        public NewHurtByTargetGoal(PathfinderMob creatureIn) {
            super(creatureIn, new Class[0]);
        }

        protected boolean m_26150_(LivingEntity entity, TargetingConditions conditions) {
            UUID ownerID;
            if (entity instanceof Player && (ownerID = ((ElephantEntity)this.f_26135_).m_21805_()) != null && entity.m_20148_().equals(ownerID)) {
                return false;
            }
            return super.m_26150_(entity, conditions);
        }
    }
}

